--[[=============================================================================
    Lua Action Code

    Copyright 2024 Key Digital Systems. All Rights Reserved.
===============================================================================]]

-- This macro is utilized to identify the version string of the driver template version used.
if (TEMPLATE_VERSION ~= nil) then
	TEMPLATE_VERSION.actions = "2016.01.08"
end

-- These actions are designed to be run during setup/configuration and not during production

-- Make sure this list matches the actions in driver.xml

function LUA_ACTION.TemplateVersion()
	TemplateVersion()
end

function LUA_ACTION.InitializeStatus()
    print("===== Action: Initialize Status =====")
    local command = "STAA"
	PackAndQueueCommand("Status", command)
end

function LUA_ACTION.ResetAll()
    print("===== Action: ResetAll =====")
    local command = "SPCDF"
	PackAndQueueCommand("ResetAll", command)
end
