--[[=============================================================================
    AVSwitch Protocol Initialization Functions

    Copyright 2024 Key Digital Systems. All Rights Reserved.
===============================================================================]]

-- This macro is utilized to identify the version string of the driver template version used.
if (TEMPLATE_VERSION ~= nil) then
	TEMPLATE_VERSION.device_messages = "2015.03.31"
end


PROTOCOL_DECLARATIONS = {}

function ON_DRIVER_EARLY_INIT.avswitch_init()

end

function ON_DRIVER_INIT.avswitch_init()
	--LogTrace("ON_DRIVER_INIT.ProtocolDeclarations()")
	for k,v in pairs(PROTOCOL_DECLARATIONS) do
		if (PROTOCOL_DECLARATIONS[k] ~= nil and type(PROTOCOL_DECLARATIONS[k]) == "function") then
			PROTOCOL_DECLARATIONS[k]()
		end
	end	
end

function ON_DRIVER_LATEINIT.avswitch_init()
end
	
function PROTOCOL_DECLARATIONS.CommandsTableInit_IR()
	LogTrace("PROTOCOL_DECLARATIONS.CommandsTableInit_IR()")

	CMDS_IR = {
		--index:  Proxy Command Name
		--value:  IR Code ID	 
		["ON"]             = "",
		["OFF"]            = "",
		["MUTE_ON"]        = "",
		["MUTE_OFF"]       = "",
		["MUTE_TOGGLE"]    = "",
		["INPUT_TOGGLE"]   = "",
		["NUMBER_0"]       = "", 	
		["NUMBER_1"]       = "",		
		["NUMBER_2"]       = "",	
		["NUMBER_3"]       = "",	
		["NUMBER_4"]       = "",	
		["NUMBER_5"]       = "",	
		["NUMBER_6"]       = "",	
		["NUMBER_7"]       = "",	
		["NUMBER_8"]       = "",	
		["NUMBER_9"]       = "",
		["STAR"]           = "",
		["DOT"]            = "",
		["INFO"]           = "", --Display
		["RECALL"]         = "",
		["PULSE_VOL_DOWN"] = "",
		["PULSE_VOL_UP"]   = "",
		["MENU"]           = "",
		["ENTER"]          = "",
		["UP"]             = "",
		["DOWN"]           = "",
		["LEFT"]           = "",
		["RIGHT"]          = "",
		["PREV"]           = "",
		["CANCEL"]         = "",
	}		
	
	-- IR ZONE Commands... We don't support IR but initialize every output
	CMDS_IR_ZONES = {}
	for i = 0, G_KD_OUTPUT_TOTAL, 1
	do
		CMDS_IR_ZONES[i] = {
			--index:  Proxy Command Name
			--value:  IR Code ID
			["CONNECT_OUTPUT"]		= "",
			["DISCONNECT_OUTPUT"]	= "",	
			["VOLUME_UP"]			= "",
			["VOLUME_DOWN"]			= "",
			["MUTE_ON"]				= "",
			["MUTE_OFF"]			= "",
			["MUTE_TOGGLE"]			= "",
		}
	end
	
	CMDS_IR[AVSWITCH_PROXY_BINDINGID] = {}	
	
end

function PROTOCOL_DECLARATIONS.CommandsTableInit_Serial()
	LogTrace("PROTOCOL_DECLARATIONS.CommandsTableInit_Serial()")

	CMDS = {
		--index:  Proxy Command Name
		--value:  Protocol Command Data
		
		--Power
		["ON"]				= "PN",
		["OFF"]				= "PF",

		--Status
		["STATUS"]			= "STAA",

		--Menu
		["INFO"]			= "",	--Display
		["GUIDE"]			= "",
		["MENU"]			= "",
		["CANCEL"]			= "",
		["UP"]				= "",
		["DOWN"]			= "",
		["LEFT"]			= "",
		["RIGHT"]			= "",
		["ENTER"]			= "",	
		["RECALL"]			= "",
		["PREV"]			= "",
		
		--Digits
		["NUMBER_0"]		= "", 	
		["NUMBER_1"]		= "",		
		["NUMBER_2"]		= "",	
		["NUMBER_3"]		= "",	
		["NUMBER_4"]		= "",	
		["NUMBER_5"]		= "",	
		["NUMBER_6"]		= "",	
		["NUMBER_7"]		= "",	
		["NUMBER_8"]		= "",	
		["NUMBER_9"]		= "",
		["STAR"]			= "",
		["DOT"]				= "",
	}
	
	CMDS[AVSWITCH_PROXY_BINDINGID] = {}
	
end

function PROTOCOL_DECLARATIONS.InputOutputTableInit()
	LogTrace("PROTOCOL_DECLARATIONS.InputOutputTableInit()")
	----------------------------------------- [*IR COMMAND HELPER TABLES*] -----------------------------------------
	
	-- IR Map Commands... We don't support IR but initialize every input
	tInputCommandMap_IR = {}
	for i = 0, G_KD_INPUT_TOTAL, 1
	do
		--Main Zone Input Selection Commands	
		tInputCommandMap_IR[i] = { 
			--index:  Connection Name
			--value:  IR Code ID
			[""] = "",
		}
	end

end	

function PROTOCOL_DECLARATIONS.PowerCommandsTableInit_Serial()
	LogTrace("PROTOCOL_DECLARATIONS.PowerCommandsTableInit_Serial()")

	-- Serial Power Commands... We don't support IR but initialize every output
	tPowerCommandMap = {}
	for i = 0, G_KD_OUTPUT_TOTAL, 1
	do
		--index:  mod 1000 value of Output Connection id
		--value:  Protocol Command Data (Power)
		tPowerCommandMap[i] = ""
	end
end

function PROTOCOL_DECLARATIONS.VolumeCommandsTableInit_Serial()
	LogTrace("PROTOCOL_DECLARATIONS.VolumeCommandsTableInit_Serial()")

	-- Convert audio state to command string. Trying this out... like an Enum for Lua
	tAudioStateMap = {
		["ENABLE"]		= "E",
		["DISABLE"]		= "D",
	}

	-- Convert audio type to command string
	tAudioTypeMap = {
		["HDMI"]		= "HA",
		["BALANCED"]	= "AA",
		["OPTICAL"]		= "DA",
	}

end

function PROTOCOL_DECLARATIONS.DeviceSpecificTableInit_Serial()
	LogTrace("PROTOCOL_DECLARATIONS.DeviceSpecificTableInit_Serial()")

	-- Convert enable state to command string. Trying this out... like an Enum for Lua
	tEnableStateMap = {
		["Enable"]		= "E",
		["Disable"]		= "D",
	}

end

function ReverseTable(a)
	local b = {}
	for k,v in pairs(a) do b[v] = k end
	return b
end
