--[[=============================================================================
    Copyright 2024 Key Digital Systems. All Rights Reserved.
===============================================================================]]

-- This macro is utilized to identify the version string of the driver template version used.
if (TEMPLATE_VERSION ~= nil) then
	TEMPLATE_VERSION.device_specific_commands = "2015.03.31"
end

--[[=============================================================================
    ExecuteCommand Code

    Define any functions for device specific commands (EX_CMD.<command>)
    received from ExecuteCommand that need to be handled by the driver.
    
    Make sure this list matches the device specific commands in driver.xml
===============================================================================]]

function EX_CMD.SetAllOutputsToInput(tParams)
    local command = string.format("SPOASI%04d", tParams.Input)
    PackAndQueueCommand("SetAllOutputsToInput", command)
end
