--[[=============================================================================
    Lua Action Code

    Copyright 2023 Key Digital Systems. All Rights Reserved.
===============================================================================]]

-- This macro is utilized to identify the version string of the driver template version used.
if (TEMPLATE_VERSION ~= nil) then
	TEMPLATE_VERSION.actions = "2016.01.08"
end

-- TODO: Create a function for each action defined in the driver

function LUA_ACTION.TemplateVersion()
	TemplateVersion()
end


function LUA_ACTION.SystemStatus()
    print("===== Action: Status =====")
    GetDeviceStatus()
end

function LUA_ACTION.SetFrontPanel(tParams)
    print(string.format("===== Action: setFrontPanel: %s =====", tParams.FrontPanel))
	PackAndQueueCommand("setFrontPanel: ", string.format("SPCFB%s", string.upper(string.sub(tParams.FrontPanel, 1, 1))))
end

function LUA_ACTION.ResetException()
    print("===== Action: resetException =====")
	PackAndQueueCommand("setFrontPanel: ", "SPCDF00")
end

function LUA_ACTION.ResetAll()
    print("===== Action: resetAll =====")
	PackAndQueueCommand("setFrontPanel: ", "SPCDF")
end
